function [density,vol,bdata] = dhist(data,bins,xyz,mod)
%This function takes a vector of numbers and plots a density normalized
%histogram of the distribution
%Synatax:   [density,volume,rawdata] = dhist(data,bins,xyz,mod);
%Input:     bins = the number of bins in the histogram.
%           data = the vector to be binned
%           xyz = the x y z size of the image volume used for normalization
%           mod = the modifier.  This is a conversion factor for changing
%               the units of the histogram, e.g., 1 bin = 10nm, thus
%               mod=10.  Default = 1.
%Output:    density = a vector of densities equal to bins.
%           vol = a vector of volumes equal to bins.
%           bdata = the actual count in each bin, before normalization.

if nargin<4     %defalut mod
    mod = 1;
end

data = data.*mod;       %change the units if needed.

%data(data==0,:) = [];
[bdata,r] = hist(data,bins);    %create the binned data vector

%r = linspace(0,ceil(max(data)),bins+1);     %create a vector of search radius per bin

%r = r.*mod;     %convert to the proper units
%lets calculate the volume of the shell: based on Vsphere = 4/3(pi)r3
%vol = (((r.^2).*pi).*4).*r(2);      %r(2) is the size of the bin.  Calculate the volume of the shell
%vol = ((((((r.^2).*pi).*2).*(r(2)-r(1))).*(2-r/xyz(1,3))).*(2-r/xyz(1,2))).*(2-r/xyz(1,1));
%vol = ((((r.^2).*pi).*2).*(r(2)-r(1))).*(2-r/xyz(1,3));
vol_s = ((4/3)*pi).*r.^3;     %sphere volumes
vol = [vol_s(1) vol_s(2:end)-vol_s(1:end-1)];
%density = bdata./vol(2:end);       %get the density value.

%vol = ((((r(2:end).^3)-(r(1:end-1).^3))./3).*pi).*4;

%vol = (((((r(2:end).^3)-(r(1:end-1).^3))./3).*pi).*2);
density = bdata./vol;       %get the density value.

plot(density);      %plot it.